#!/bin/sh
#
# bstnStatusCtl.sh: start/stop/restart/status bstnStatus
#
# Copyright (C) Netmore, Inc - All Rights Reserved
# Unauthorized copying of this file, via any medium is strictly prohibited
# Proprietary and confidential.  Written 2016.
#
# This script needs to run from the appropriate startup location given the
# version of Linux it is installed on.

# Requires the following directories in bstn:
# {base}/var/run
# {base}/bin

# Requires the launcher script in the bin directory

# The location of where Base Station Services is installed
# Do not change, this comment is token and is replaced when the platform is built
bstnBasePath=/opt/bstn

# The name of the application to be executed
bstnApplicationName=bstnStatus.sh

# Arguments to pass to the application
bstnApplicationArgs=""

# Should not need to modify anything beyond this line
bstnLauncher=$bstnBasePath/bin/bstn-launch.sh
bstnApplication=$bstnBasePath/bin/$bstnApplicationName
bstnPidPath=$bstnBasePath/var/run
mkdir -p $bstnPidPath
bstnPidFile=$bstnPidPath/$bstnApplicationName-launch.pid

SSD=/usr/sbin/start-stop-daemon
if [ ! -f $SSD ] ; then
  SSD=start-stop-daemon
fi

#logger "$0 $1"

if [ $# -ge 2 ] ; then
  bstnApplicationArgs=$2
fi

case $1 in
restart)
    logger "$0 : Restarting $bstnApplication"
    # start method performs a stop
    $0 start $bstnApplicationArgs
    ;;

start)
    # stop
    logger "$0 : Stopping $bstnApplication"
    $SSD -o --pidfile $bstnPidFile --stop --retry forever/TERM 2>&1 | logger
    if [ 0 != $? ]; then
      logger "$0 : Error stopping $bstnApplication returned $?"
    fi
    rm -f $bstnPidFile
    sync

    # start
    logger "$0 : Starting $bstnApplication $bstnApplicationArgs"
    $SSD --background --make-pidfile --pidfile $bstnPidFile --start --exec $bstnLauncher -- $bstnApplication $bstnApplicationArgs 2>&1 | logger
    if [ 0 != $? ]; then
    logger "$0 : Error start of $bstnApplication returned $?"
    fi
    ;;

stop)
    logger "$0 : Stopping $bstnApplication"
    $SSD -o --pidfile $bstnPidFile --stop --retry forever/TERM 2>&1 | logger
    if [ 0 != $? ]; then
      logger "$0 : Error stopping $bstnApplication returned $?"
    fi
    rm -f $bstnPidFile
    ;;

status)
    $SSD --pidfile $bstnPidFile $bstnApplicationName --status
    case $? in
      0)
        echo "$bstnApplicationName is running"
        ;;
      1)
        echo "Warning $bstnApplicationName is not running but pid file exists"
        ;;
      2)
        echo "$bstnApplicationName is not running"
        ;;
      3)
        echo "Unable to determine status of $bstnApplicationName"
        ;;
      *)
        echo "Undocumented status code $?"
        ;;
    esac
    ;;
*)
    echo "usage: $0 [start|stop|restart]"
    exit 1
    ;;
esac

exit 0

#
# Notes
# - As long as there is a pid file and the pid file represents the running
#   process, the start mechanism will not allow multiple applications to be
#   started at the same time. Start does some simple checking to determine if
#   their is a pid file, if there is, it logs the condition, and restarts
#   the process.
#   A more complete way would be to use Debian's status_of_proc which is not
#   found on the g0gw or the kerlink. This would not restart the process if
#   the pid was associated with named application.
#   For our application, the complete way would be nice but is not necessary
#   given the extra complication.
# - If something happens to the pid file, the start-stop-daemon is unable to
#   stop the process. The killall command will not work because the name
#   associated with the process is the launcher with the application as an
#   argument; using killall would kill any process created with the launcher.
#
