#!/bin/sh

# Copyright (C) Netmore, Inc - All Rights Reserved
# Unauthorized copying of this file, via any medium is strictly prohibited
# Proprietary and confidential.  Written 2025.

sDir="/var/persistent/NetmoreAgent"
sFile="${sDir}/status.json"
rFile="/opt/bstn/etc/bstn_registration_cfg.json"

checkIn="/etc/init.d/annex-client restart"

# last status
lBstnStatus="Unknown"
lStatusStatus="Unknown"
lPidwatchStatus="Unknown"
lReg="Unknown"
sName="Unset"

# determine advanced features based on OS version
osVerMajor=$(grep -E '^VERSION_ID=' /etc/os-release 2>/dev/null | cut -d= -f2 | tr -d '"' | cut -d. -f1)
case $osVerMajor in
  ''|*[!0-9]* ) osVerMajor=0 ;;
esac
advFeatures=0
# if osVerMajor >= 7 then allow advanced features
if [ $osVerMajor -ge 7 ] ; then
  advFeatures=1
fi

while [ 1 -lt 2 ] ; do
  if [ -d $sDir ] ; then
    cReg="Not Registered"
    cFwd="Not Running"

    pBstn=$(pidof -s bstn-dispatch)
    if [ 0 -eq $? ] && [ "$pBstn" != "" ] ; then
      cFwd="Running"
    else
      pBstn=0
    fi

    if [ -f $rFile ] ; then
      cReg="Registered"
      sName=$(grep -m1 -oE '"Network Server"[[:space:]]*:[[:space:]]*"[^\"]+"' $rFile | cut -d: -f2 | tr -d ' "')
    else
      cReg="Unregistered"
    fi

    # Update status file
    if [ $advFeatures -eq 1 ] ; then
      pStatus=$(pidof -s bstnStatus.sh)
      if [ 0 -eq $? ] && [ "$pStatus" != "" ] ; then
        cStatus="Running"
      else
        pStatus=0
        cStatus="Not Running"
      fi

      pPidwatch=$(pidof -s bstn-pidwatch)
      if [ 0 -eq $? ] && [ "$pPidwatch" != "" ] ; then
        cPidwatch="Running"
      else
        pPidwatch=0
        cPidwatch="Not Running"
      fi

      printf "{\"AppInfo\": \"Agent is $cFwd. Gateway is $cReg ($sName).\n\"," > $sFile
      printf "\"pid\":\n[\n" >> $sFile
      printf "  {\"name\":\"Packet Forwarder\", \"pid\":\"$pBstn\"},\n" >> $sFile
      printf "  {\"name\":\"PID Monitor\", \"pid\":\"$pPidwatch\"},\n" >> $sFile
      printf "  {\"name\":\"Status Monitor\", \"pid\":\"$pStatus\"}\n" >> $sFile
      printf "]\n}\n" >> $sFile

      # Update if data has changed
      if [ "$lBstnStatus" != "$pBstn" ] || [ "$lReg" != "$cReg" ] || [ "$lStatusStatus" != "$cStatus" ] || [ "$lPidwatchStatus" != "$cPidwatch" ] ; then
        $checkIn
        lBstnStatus=$pBstn
        lReg=$cReg
        lStatusStatus=$cStatus
        lPidwatchStatus=$cPidwatch
      fi
    else
      printf "{\"AppInfo\": \"Agent is $cFwd. Gateway is $cReg ($sName)\",\n\"pid\":\"$pBstn\"\n}\n" > $sFile
    fi
    sync

    # Update if data has changed
    if [ "$lBstnStatus" != "$pBstn" ] || [ "$lReg" != "$cReg" ] ; then
      $checkIn
      lBstnStatus=$pBstn
      lReg=$cReg
    fi
  fi

  sleep 30
done

exit 0
